/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.EventsRenderer;
import org.das2.graph.PitchAngleDistributionRenderer;
import org.das2.graph.PolarPlotRenderer;
import org.das2.graph.RGBImageRenderer;
import org.das2.graph.TickCurveRenderer;
import org.das2.graph.VectorPlotRenderer;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;

public enum RenderType {
    spectrogram,
    nnSpectrogram,
    hugeScatter,
    series,
    scatter,
    colorScatter,
    stairSteps,
    fillToZero,
    digital,
    image,
    pitchAngleDistribution,
    polar,
    eventsBar,
    stackedHistogram,
    vectorPlot,
    bounds,
    internal,
    orbitPlot,
    contour;


    public static boolean acceptsData(RenderType rt, QDataSet ds) {
        if (null == rt) {
            return true;
        }
        switch (rt) {
            case spectrogram: 
            case nnSpectrogram: {
                if (SemanticOps.isTableDataSet((QDataSet)ds)) {
                    return true;
                }
                if (Schemes.isXYZScatter((QDataSet)ds)) {
                    return true;
                }
                return Schemes.isLegacyXYZScatter((QDataSet)ds);
            }
            case hugeScatter: {
                switch (ds.rank()) {
                    case 2: {
                        if (SemanticOps.isBundle((QDataSet)ds)) {
                            for (int i = 0; i < ds.length(0); ++i) {
                                QDataSet ds1 = DataSetOps.unbundle((QDataSet)ds, (int)i);
                                if (UnitsUtil.isIntervalOrRatioMeasurement((Units)SemanticOps.getUnits((QDataSet)ds1))) continue;
                                return false;
                            }
                            return true;
                        }
                        return SemanticOps.isRank2Waveform((QDataSet)ds);
                    }
                    case 1: {
                        Units u = SemanticOps.getUnits((QDataSet)ds);
                        return UnitsUtil.isIntervalOrRatioMeasurement((Units)u);
                    }
                }
                return false;
            }
            case series: 
            case scatter: 
            case stairSteps: 
            case fillToZero: {
                switch (ds.rank()) {
                    case 1: {
                        Units u = SemanticOps.getUnits((QDataSet)ds);
                        return UnitsUtil.isIntervalOrRatioMeasurement((Units)u);
                    }
                    case 2: {
                        return true;
                    }
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
            case colorScatter: {
                switch (ds.rank()) {
                    case 2: {
                        if (SemanticOps.isBundle((QDataSet)ds)) {
                            for (int i = 0; i < ds.length(0); ++i) {
                                QDataSet ds1 = DataSetOps.unbundle((QDataSet)ds, (int)i);
                                if (UnitsUtil.isIntervalOrRatioMeasurement((Units)SemanticOps.getUnits((QDataSet)ds1))) continue;
                                return false;
                            }
                            return true;
                        }
                        return false;
                    }
                    case 1: {
                        return ds.property("PLANE_0") != null;
                    }
                }
                return false;
            }
            case digital: {
                if (SemanticOps.isBundle((QDataSet)ds)) {
                    for (int i = 0; i < ds.length(0); ++i) {
                        QDataSet ds1 = DataSetOps.unbundle((QDataSet)ds, (int)i);
                        if (UnitsUtil.isIntervalOrRatioMeasurement((Units)SemanticOps.getUnits((QDataSet)ds1))) continue;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            case image: {
                return RGBImageRenderer.acceptsData((QDataSet)ds);
            }
            case pitchAngleDistribution: {
                return PitchAngleDistributionRenderer.acceptsData((QDataSet)ds);
            }
            case polar: {
                return PolarPlotRenderer.acceptsData((QDataSet)ds);
            }
            case eventsBar: {
                return EventsRenderer.acceptsData((QDataSet)ds);
            }
            case vectorPlot: {
                return VectorPlotRenderer.acceptsData((QDataSet)ds);
            }
            case orbitPlot: {
                return TickCurveRenderer.acceptsData((QDataSet)ds);
            }
            case contour: {
                return ds.rank() == 2;
            }
            case stackedHistogram: {
                return ds.rank() == 2;
            }
            case bounds: {
                return Schemes.isBoundingBox((QDataSet)ds) || Schemes.isArrayOfBoundingBox((QDataSet)ds) || Schemes.isTrajectory((QDataSet)ds) || ds.rank() > 1 && ds.length(0) == 2 || Schemes.isRank2Bins((QDataSet)ds);
            }
        }
        return true;
    }
}

